unit GLWektory;

interface

uses OpenGL;

function JednostkowyWektorNormalny(punkt1,punkt2,punkt3 :TGLArrayf3) :TGLArrayf3;

implementation

function Roznica3fv(punkt1,punkt2 :TGLArrayf3) :TGLArrayf3;
var i :Integer;
begin
for i:=0 to 2 do Result[i]:=punkt2[i]-punkt1[i];
end;

function IloczynWektorowy3fv(a,b :TGLArrayf3) :TGLArrayf3;
const x=0;y=1;z=2;
begin
//zmienic na wskazniki
Result[x]:=a[y]*b[z]-a[z]*b[y];
Result[y]:=-(a[x]*b[z]-a[z]*b[x]);
Result[z]:=a[x]*b[y]-a[y]*b[x];
end;

function NormalizujWektor3fv(wektor :TGLArrayf3) :TGLArrayf3;
var
  wsp :Single;
  i :Integer;
begin
wsp:=Sqr(wektor[0])+Sqr(wektor[1])+Sqr(wektor[2]);
wsp:=Sqrt(wsp);
for i:=0 to 2 do Result[i]:=wektor[i]/wsp;
end;

function JednostkowyWektorNormalny(punkt1,punkt2,punkt3 :TGLArrayf3) :TGLArrayf3;
begin
Result:=NormalizujWektor3fv(IloczynWektorowy3fv(Roznica3fv(punkt1,punkt2),Roznica3fv(punkt1,punkt3)));
end;

end.
